/*
* Script: LITabs
* Version: 1.0
* Author: Peter Törnstrand <peter[at]tornstrand[dot]com>
* Date: 2006-07-16
*/

var tabs = new Array();
var contents = new Array();

/**
* Initialize tabs
*/
var initTabs = function()
{
	var tab_container = document.getElementById('content_tabs');
	var DIVheight = 0;
	var Aheight = document.getElementById('active_tab').offsetHeight;
	
	// looking for LI's
	for ( i=0; i<tab_container.childNodes.length; i++)
	{
		tmpLI = null;
		tmpA = null;
		tmpDIV = null;
		
		if (tab_container.childNodes[i].nodeName=='LI' && tab_container.childNodes[i].parentNode==tab_container)
		{
			tmpLI = tab_container.childNodes[i];
			
			// looking for A's
			for (j=0; j<tmpLI.childNodes.length; j++)
			{
				if(tmpLI.childNodes[j].nodeName=='A' && tmpLI.childNodes[j].className=='tab')
				{
					tmpA = tmpLI.childNodes[j];
					tabs.push(tmpA);
					
					// looking for DIV's
					for (k=0; k<tmpLI.childNodes.length; k++)
					{
						if (tmpLI.childNodes[k].nodeName=='DIV' && tmpLI.childNodes[k].className=='tab_content')
						{
							tmpDIV = tmpLI.childNodes[k];
							contents.push(tmpDIV);
							
							if (tmpA.id!='active_tab') {
								tmpDIV.style.display = 'none';
							} else {
								DIVheight = tmpDIV.offsetHeight;
							}
							
							tmpA.onclick = function() {
								hideAllContents();
								showMyContents(this);
							} // end function
						} // end if
					} // end for
				} // end if
			} // end for
		} // end if
	} // end for
	
	// set height on UL
	tab_container.style.height = (DIVheight+Aheight) + 'px';
}

/**
* Show contents when tab is clicked
* @param tab The tab beeing clicked
*/
var showMyContents = function(tab)
{
	// set tab active
	tab.id = 'active_tab';
	
	// get the LI element
	elems = tab.parentNode;
	
	for (i=0; i<elems.childNodes.length; i++)
	{
		if (elems.childNodes[i].nodeName=='DIV' && elems.childNodes[i].className=='tab_content')
		{
			elems.childNodes[i].style.display = 'block';
			tmpHeight = elems.childNodes[i].offsetHeight;
			tmpHeight += document.getElementById('active_tab').offsetHeight;
			document.getElementById('content_tabs').style.height = tmpHeight + 'px';
		}
	}
}

/**
* Hide all contents and set all tabs inactive
*/
var hideAllContents = function()
{
	for (i=0; i<contents.length; i++) {
		contents[i].style.display = 'none';
	}
	for (i=0; i<tabs.length; i++) {
		tabs[i].id = '';
	}
}

window.onload = function() {
	initTabs();
}